<?php

namespace App\Http\Controllers\API;

use App\Models\AppointmentType;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inertia\Inertia;
use App\Http\Controllers\Controller;
use App\Http\Resources\API\AppCarouselsResourse;
use App\Http\Resources\API\ArchiveCategoriesResource;
use App\Http\Resources\API\BlogCategoriesResource;
use App\Http\Resources\API\TherapistCommunityCategoriesResource;
use App\Http\Resources\API\TherapistCommunitysResource;
use App\Http\Resources\API\ArchivesResource;
use App\Http\Resources\API\BroadcastsResource;
use App\Http\Resources\API\TherapistCommunityReviewsResource;
use App\Http\Resources\API\TherapistCategoriesResource;
use App\Http\Resources\API\TherapistMainCategoriesResource;
use App\Http\Resources\API\EventsResource;
use App\Http\Resources\API\PostsResource;
use App\Http\Resources\API\PodcastsResource;
use App\Http\Resources\API\TherapistReviewsResource;
use App\Http\Resources\API\CompanyPagesResource;
use App\Http\Resources\API\TherapistsResource;
use App\Http\Resources\API\TagsResource;
use App\Http\Resources\API\TestimonialsResource;
use App\Http\Resources\API\AppointmentTypesResource;
use App\Http\Resources\API\ServiceCategoriesResource;
use App\Http\Resources\API\ServicesResource;
use App\Models\AppCarousel;
use App\Models\ArchiveCategory;
use App\Models\BlogCategory;
use App\Models\TherapistCommunity;
use App\Models\TherapistCommunityCategory;
use App\Models\City;
use App\Models\Country;
use App\Models\Therapist;
use App\Models\Archive;
use App\Models\Broadcast;
use App\Models\TherapistCommunityReview;
use App\Models\State;
use App\Models\TherapistCategory;
use App\Models\TherapistMainCategory;
use App\Models\Event;
use App\Models\Post;
use App\Models\Podcast;
use App\Models\TherapistReview;
use App\Models\Tag;
use App\Models\Testimonial;
use App\Models\CompanyPage;
use App\Models\Service;
use App\Models\ServiceCategory;

class APIGeneralController extends Controller
{
    public function __construct()
    {
        // $this->middleware('auth');
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapistReviews($req = null, $user_name)
    {
        if ($req != null) {
            $reviews =  TherapistReview::withAll()->active()->whereHas('therapist', function ($q) use ($user_name) {
                $q->where('user_name', $user_name);
                $q->active();
            });
            if ($req->column && $req->column != null && $req->search != null) {
                $reviews = $reviews->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $reviews = $reviews->whereLike(['comment', 'rating'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $reviews = $reviews->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $reviews = $reviews->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $reviews = $reviews->get();
            } else {
                $reviews = $reviews->paginate($req->perPage ?? 10);
            }
            $reviews = TherapistReviewsResource::collection($reviews)->response()->getData(true);
            return $reviews;
        }
        $reviews = TherapistReview::withAll()->active()->whereHas('therapist', function ($q) use ($user_name) {
            $q->where('user_name', $user_name);
            $q->active();
        })->orderBy('id', 'desc')->paginate(10);
        $reviews = TherapistReviewsResource::collection($reviews)->response()->getData(true);
        return $reviews;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapistPodcasts($req = null, $user_name)
    {
        if ($req != null) {
            $podcasts =  Podcast::withAll()->active()->whereHas('therapist', function ($q) use ($user_name) {
                $q->where('user_name', $user_name);
                $q->active();
            });
            if ($req->column && $req->column != null && $req->search != null) {
                $podcasts = $podcasts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $podcasts = $podcasts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $podcasts = $podcasts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $podcasts = $podcasts->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $podcasts = $podcasts->get();
            } else {
                $podcasts = $podcasts->paginate($req->perPage ?? 10);
            }
            $podcasts = PodcastsResource::collection($podcasts)->response()->getData(true);
            return $podcasts;
        }
        $podcasts = Podcast::withAll()->active()->whereHas('therapist', function ($q) use ($user_name) {
            $q->where('user_name', $user_name);
            $q->active();
        })->orderBy('id', 'desc')->paginate(10);
        $podcasts = PodcastsResource::collection($podcasts)->response()->getData(true);
        return $podcasts;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapistBroadcasts($req = null, $user_name)
    {
        if ($req != null) {
            $broadcasts =  Broadcast::withAll()->active()->whereHas('therapist', function ($q) use ($user_name) {
                $q->where('user_name', $user_name);
                $q->active();
            });
            if ($req->column && $req->column != null && $req->search != null) {
                $broadcasts = $broadcasts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $broadcasts = $broadcasts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $broadcasts = $broadcasts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $broadcasts = $broadcasts->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $broadcasts = $broadcasts->get();
            } else {
                $broadcasts = $broadcasts->paginate($req->perPage ?? 10);
            }
            $broadcasts = BroadcastsResource::collection($broadcasts)->response()->getData(true);
            return $broadcasts;
        }
        $broadcasts = Broadcast::withAll()->active()->whereHas('therapist', function ($q) use ($user_name) {
            $q->where('user_name', $user_name);
            $q->active();
        })->orderBy('id', 'desc')->paginate(10);
        $broadcasts = BroadcastsResource::collection($broadcasts)->response()->getData(true);
        return $broadcasts;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapistCommunityReviews($req = null, $user_name)
    {
        if ($req != null) {
            $reviews =  TherapistCommunityReview::withAll()->active()->whereHas('therapist_community', function ($q) use ($user_name) {
                $q->where('user_name', $user_name);
                $q->active();
            });
            if ($req->column && $req->column != null && $req->search != null) {
                $reviews = $reviews->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $reviews = $reviews->whereLike(['comment', 'rating'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $reviews = $reviews->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $reviews = $reviews->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $reviews = $reviews->get();
            } else {
                $reviews = $reviews->paginate($req->perPage ?? 10);
            }
            $reviews = TherapistCommunityReviewsResource::collection($reviews)->response()->getData(true);
            return $reviews;
        }

        $reviews = TherapistCommunityReview::withAll()->active()->whereHas('therapist_community', function ($q) use ($user_name) {
            $q->where('user_name', $user_name);
            $q->active();
        })->orderBy('id', 'desc')->paginate(10);
        $reviews = TherapistCommunityReviewsResource::collection($reviews)->response()->getData(true);
        return $reviews;
    }
    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapists($req = null)
    {
        if ($req != null) {
            $therapists =  Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved();
            if ($req->therapist_category) {
                $therapists = $therapists->whereHas('therapist_categories', function ($q) use ($req) {
                    $q->where('therapist_categories.slug', $req->therapist_category);
                });
            }
            if ($req->country) {
                $therapists = $therapists->where('country_id', $req->country);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapists = $therapists->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $therapists = $therapists->whereLike(['first_name', 'last_name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $therapists = $therapists->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $therapists = $therapists->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $therapists = $therapists->get();
            } else {
                $therapists = $therapists->paginate($req->perPage ?? 10);
            }
            $therapists = TherapistsResource::collection($therapists)->response()->getData(true);
            return $therapists;
        }
        $therapists = Therapist::withAll()->orderBy('id', 'desc');
        if ($req->all) {
            $therapists = $therapists->get();
        } else {
            $therapists = $therapists->paginate(10);
        }
        $therapists = TherapistsResource::collection($therapists)->response()->getData(true);
        return $therapists;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchTherapistCommunitys($req = null)
    {
        if ($req != null) {
            $therapist_communitys =  TherapistCommunity::withAll()->has('user')->whereNotNull('user_name')->active()->approved();
            // dd($req->all());
            if ($req->therapist_community_category) {
                $therapist_communitys = $therapist_communitys->whereHas('therapist_community_categories', function ($q) use ($req) {
                    $q->where('therapist_community_categories.slug', $req->therapist_community_category);
                });
            }
            if ($req->country) {
                $therapist_communitys = $therapist_communitys->where('country_id', $req->country);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $therapist_communitys = $therapist_communitys->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $therapist_communitys = $therapist_communitys->whereLike(['first_name', 'last_name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $therapist_communitys = $therapist_communitys->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $therapist_communitys = $therapist_communitys->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $therapist_communitys = $therapist_communitys->get();
            } else {
                $therapist_communitys = $therapist_communitys->paginate($req->perPage ?? 10);
            }
            $therapist_communitys = TherapistCommunitysResource::collection($therapist_communitys)->response()->getData(true);
            return $therapist_communitys;
        }
        $therapist_communitys = TherapistCommunity::withAll()->orderBy('id', 'desc');
        if ($req->all) {
            $therapist_communitys = $therapist_communitys->get();
        } else {
            $therapist_communitys = $therapist_communitys->paginate(10);
        }
        $therapist_communitys = TherapistCommunitysResource::collection($therapist_communitys)->response()->getData(true);
        return $therapist_communitys;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchEvents($req = null)
    {
        if ($req != null) {
            $events =  Event::withAll()->active()->upcoming();
            if ($req->month) {
                $months = [
                    'jan' => 1, 'feb' => 2, 'mar' => 3, 'apr' => 4, 'may' => 5, 'jun' => 6, 'jul' => 7,
                    'aug' => 8, 'sep' => 9, 'oct' => 10, 'nov' => 11, 'dec' => 12
                ];
                if (isset($months[$req->month])) {
                    $events = $events->whereMonth('starts_at', $months[$req->month]);
                }
            }
            if ($req->address) {
                $events = $events->whereLike('address', $req->address);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $events = $events->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $events = $events->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $events = $events->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $events = $events->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $events = $events->get();
            } else {
                $events = $events->paginate($req->perPage ?? 10);
            }
            $events = EventsResource::collection($events)->response()->getData(true);
            return $events;
        }
        $events = Event::withAll()->active()->upcoming()->orderBy('id', 'desc')->paginate(10);
        $events = EventsResource::collection($events)->response()->getData(true);
        return $events;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchPosts($req = null)
    {
        if ($req != null) {
            $posts =  Post::withAll()->active()->hasModulePermissions();
            if ($req->tag) {
                $posts = $posts->whereHas('tags', function ($q) use ($req) {
                    $q->where('slug', $req->tag);
                });
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $posts = $posts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $posts = $posts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $posts = $posts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $posts = $posts->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $posts = $posts->get();
            } else {
                $posts = $posts->paginate($req->perPage ?? 10);
            }
            $posts = PostsResource::collection($posts)->response()->getData(true);
            return $posts;
        }
        $posts = Post::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
        $posts = PostsResource::collection($posts)->response()->getData(true);
        return $posts;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchArchives($req = null)
    {
        if ($req != null) {
            $archives =  Archive::withAll()->active()->hasModulePermissions();
            if ($req->tag) {
                $archives = $archives->whereHas('tags', function ($q) use ($req) {
                    $q->where('slug', $req->tag);
                });
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $archives = $archives->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $archives = $archives->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $archives = $archives->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $archives = $archives->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $archives = $archives->get();
            } else {
                $archives = $archives->paginate($req->perPage ?? 10);
            }
            $archives = ArchivesResource::collection($archives)->response()->getData(true);
            return $archives;
        }
        $archives = Archive::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
        $archives = ArchivesResource::collection($archives)->response()->getData(true);
        return $archives;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchBroadcasts($req = null)
    {
        if ($req != null) {
            $broadcasts =  Broadcast::withAll()->active()->hasModulePermissions();
            if ($req->tag) {
                $broadcasts = $broadcasts->whereHas('tags', function ($q) use ($req) {
                    $q->where('slug', $req->tag);
                });
            }
            if ($req->type) {
                $broadcasts = $broadcasts->whereLike('file_type', $req->type);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $broadcasts = $broadcasts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $broadcasts = $broadcasts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $broadcasts = $broadcasts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $broadcasts = $broadcasts->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $broadcasts = $broadcasts->get();
            } else {
                $broadcasts = $broadcasts->paginate($req->perPage ?? 10);
            }
            $broadcasts = BroadcastsResource::collection($broadcasts)->response()->getData(true);
            return $broadcasts;
        }
        $broadcasts = Broadcast::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
        $broadcasts = BroadcastsResource::collection($broadcasts)->response()->getData(true);
        return $broadcasts;
    }

    /********* Getter For Pagination, Searching And Sorting  ***********/
    public static function searchPodcasts($req = null)
    {
        if ($req != null) {
            $podcasts =  Podcast::withAll()->active()->hasModulePermissions();
            if ($req->tag) {
                $podcasts = $podcasts->whereHas('tags', function ($q) use ($req) {
                    $q->where('slug', $req->tag);
                });
            }
            if ($req->type) {
                $podcasts = $podcasts->whereLike('file_type', $req->type);
            }
            if ($req->column && $req->column != null && $req->search != null) {
                $podcasts = $podcasts->whereLike($req->column, $req->search);
            } else if ($req->search && $req->search != null) {
                $podcasts = $podcasts->whereLike(['name', 'description'], $req->search);
            }
            if ($req->sort_field != null && $req->sort_type != null) {
                $podcasts = $podcasts->OrderBy($req->sort_field, $req->sort_type);
            } else {
                $podcasts = $podcasts->OrderBy('id', 'desc');
            }
            if ($req->all) {
                $podcasts = $podcasts->get();
            } else {
                $podcasts = $podcasts->paginate($req->perPage ?? 10);
            }
            $podcasts = PodcastsResource::collection($podcasts)->response()->getData(true);
            return $podcasts;
        }
        $podcasts = Podcast::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
        $podcasts = PodcastsResource::collection($podcasts)->response()->getData(true);
        return $podcasts;
    }

       /********* Getter For Pagination, Searching And Sorting  ***********/
       public static function searchServices($req = null)
       {
           if ($req != null) {
               $services =  Service::withAll()->active()->approved()->hasModulePermissions();
               if ($req->tag) {
                   $services = $services->whereHas('tags', function ($q) use ($req) {
                       $q->where('slug', $req->tag);
                   });
               }
               if($req->service_category){
                $services = $services->whereHas('service_category',function($q) use($req){
                    $q->where('slug',$req->service_category);
                });
            }
                if($req->service_category_id){
                    $services = $services->where('service_category_id',$req->service_category_id);
                }
               if ($req->column && $req->column != null && $req->search != null) {
                   $services = $services->whereLike($req->column, $req->search);
               } else if ($req->search && $req->search != null) {
                   $services = $services->whereLike(['name', 'description'], $req->search);
               }
               if ($req->sort_field != null && $req->sort_type != null) {
                   $services = $services->OrderBy($req->sort_field, $req->sort_type);
               } else {
                   $services = $services->OrderBy('id', 'desc');
               }
               if ($req->all) {
                   $services = $services->get();
               } else {
                   $services = $services->paginate($req->perPage ?? 10);
               }
               $services = ServicesResource::collection($services)->response()->getData(true);
               return $services;
           }
           $services = Service::withAll()->hasModulePermissions()->orderBy('id', 'desc')->paginate(10);
           $services = ServicesResource::collection($services)->response()->getData(true);
           return $services;
       }

    public static function getCountries($request)
    {
        $countries = Country::active()->get();
        return $countries;
    }
    public static function getStates($request)
    {
        $states = State::active()->where('country_id', $request->country_id)->get();
        return $states;
    }

    public static function getTestimonials($request)
    {
        $testimonials = Testimonial::active()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $testimonials = TestimonialsResource::collection($testimonials);
        return $testimonials;
    }

    public static function getTherapistCommunityCategories($request)
    {
        $therapist_community_categories = TherapistCommunityCategory::active()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $therapist_community_categories = TherapistCommunityCategoriesResource::collection($therapist_community_categories);
        return $therapist_community_categories;
    }

    public static function getTags($request)
    {
        $tags = Tag::active()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $tags = TagsResource::collection($tags);
        return $tags;
    }
    public static function getAppCarousels($request)
    {
        $app_carousels = AppCarousel::active()->get();
        $app_carousels = AppCarouselsResourse::collection($app_carousels);
        return $app_carousels;
    }

    public static function getBlogCategories($request)
    {
        $blog_categories = BlogCategory::active()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $blog_categories = BlogCategoriesResource::collection($blog_categories);
        return $blog_categories;
    }

    public static function getArchiveCategories($request)
    {
        $archive_categories = ArchiveCategory::active()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $archive_categories = ArchiveCategoriesResource::collection($archive_categories);
        return $archive_categories;
    }

    public static function getServiceCategories($request)
    {
        $service_categories = ServiceCategory::active()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $service_categories = ServiceCategoriesResource::collection($service_categories);
        return $service_categories;
    }


    public static function getTherapistCategories($request)
    {

        $therapist_categories = TherapistCategory::active()
        ->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $therapist_categories = TherapistCategoriesResource::collection($therapist_categories);
        return $therapist_categories;
    }

    public static function getTherapistMainCategoriesWithChildrens($request)
    {
        $therapist_main_categories = TherapistMainCategory::active()->whereHas('categories', function ($q) {
            $q->active();
        })->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->withAll()->withChildrens()->active();
        $therapist_main_categories = $therapist_main_categories->get();

        $therapist_main_categories = TherapistMainCategoriesResource::collection($therapist_main_categories);
        return $therapist_main_categories;
    }

    public static function getCities($request)
    {
        $cities = City::active()->where('country_id', $request->country_id)->where('state_id', $request->state_id)->get();
        return $cities;
    }
    public static function getFeaturedTherapists($request)
    {
        $featured_therapists = Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->featured()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $featured_therapists = TherapistsResource::collection($featured_therapists);
        return $featured_therapists;
    }
    public static function getTopRatedTherapists($request)
    {
        $featured_therapists = Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->featured()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->topRated()->get();
        $featured_therapists = TherapistsResource::collection($featured_therapists);
        return $featured_therapists;
    }

    public static function getFeaturedTags($request)
    {
        $featured_tags = Tag::withAll()->active()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $featured_tags = TagsResource::collection($featured_tags);
        return $featured_tags;
    }

    public static function getFeaturedEvents($request)
    {
        $featured_events = Event::withAll()->hasModulePermissions()->active()->upcoming()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $featured_events = EventsResource::collection($featured_events);
        return $featured_events;
    }

    public static function getSpotlightTherapists($request)
    {
        $spotlight_therapists = Therapist::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->featured();

        $spotlight_therapists = $spotlight_therapists->get();
        $spotlight_therapists = TherapistsResource::collection($spotlight_therapists);
        return $spotlight_therapists;
    }

    public static function getFeaturedTherapistCommunitys($request)
    {
        $featured_therapist_communitys = TherapistCommunity::withAll()->has('user')->whereNotNull('user_name')->active()->approved()->featured()->when($request->limit, function ($query) use ($request) {
            $query->take($request->limit);
        })->get();
        $featured_therapist_communitys = TherapistCommunitysResource::collection($featured_therapist_communitys);
        return $featured_therapist_communitys;
    }
    public static function getCompanyPage($request, $slug)
    {
        $company_page = CompanyPage::withAll()->where('slug', $slug)->first();
        $company_page = new CompanyPagesResource($company_page);
        return $company_page;
    }
    public static function getAppointmentTypes($request)
    {
        $appointment_types = AppointmentType::active()->get();
        $appointment_types = AppointmentTypesResource::collection($appointment_types);
        return $appointment_types;
    }

}
